/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mcjty.rftoolsdim.dimension.data.ClientDimensionData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class PackagePropageDataToClients {
    private final Map<ResourceLocation, ClientDimensionData.ClientData> clientDataMap;
    private final long seed;

    public PackagePropageDataToClients(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.clientDataMap = new HashMap<ResourceLocation, ClientDimensionData.ClientData>(size);
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = buf.m_130281_();
            this.clientDataMap.put(id, ClientDimensionData.ClientData.create(buf));
        }
        this.seed = buf.readLong();
    }

    public PackagePropageDataToClients(Map<ResourceLocation, ClientDimensionData.ClientData> clientDataMap, long seed) {
        this.clientDataMap = clientDataMap;
        this.seed = seed;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.clientDataMap.size());
        for (Map.Entry<ResourceLocation, ClientDimensionData.ClientData> entry : this.clientDataMap.entrySet()) {
            buf.m_130085_(entry.getKey());
            entry.getValue().writeToBuf(buf);
        }
        buf.writeLong(this.seed);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> ClientDimensionData.get().updateDataFromServer(this.clientDataMap, this.seed));
        ctx.setPacketHandled(true);
    }
}

